/*  ---------------------------------------------------
    Template Name: ovalmattress
    Description:  ovalmattress HTML Template
    Author: hamidreza mohammadi
    Author URI: alotoshak.ir
    Version: 1.0
    Created: hamid
---------------------------------------------------------  */

'use strict';

(function($) {

    /*------------------
        Preloader
    --------------------*/
    $(window).on('load', function() {
        $(".loader").fadeOut();
        $("#preloder").delay(200).fadeOut("slow");
    });

    Fancybox.bind("[data-fancybox]", {
        hideScrollbar: false,
    });
    /*------------------
		Navigation
	--------------------*/
    $(".mobile-menu").slicknav({
        prependTo: '#mobile-menu-wrap',
        allowParentLinks: true
    });

    /*------------------
        Carousel Slider
    --------------------*/
    var hero_s = $(".hs-slider");
    hero_s.owlCarousel({
        loop: true,
        margin: 0,
        nav: true,
        items: 1,
        dots: false,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        navText: ['<span class="arrow_carrot-left"></span>', '<span class="arrow_carrot-right"></span>'],
        smartSpeed: 1200,
        autoHeight: false,
        autoplay: true
    });

    /*------------------
        Team Slider
    --------------------*/
    $(".categories-slider").owlCarousel({
        loop: true,
        margin: 20,
        items: 3,
        dots: false,
        nav: true,
        navText: ['<span class="arrow_carrot-left"></span>', '<span class="arrow_carrot-right"></span>'],
        stagePadding: 120,
        smartSpeed: 1200,
        autoHeight: false,
        autoplay: true,
        responsive: {
            0: {
                items: 1,
                stagePadding: 0
            },
            768: {
                items: 2,
                stagePadding: 0
            },
            992: {
                items: 2
            },
            1200: {
                items: 3
            }
        }
    });
    $("#send_contactbox").click(function(e) {
        e.preventDefault();
        var name_family = $('#name_family').val();
        var email = $('#email').val();
        var country = $('#country').find(":selected").val();
        var mobile_phone = $('#mobile_phone').val();
        var description = $('#description').val();
        $(".lds-dual-ring").css("display", "inline-block");
        $.ajax({
            type: "post",
            url: "/wp-admin/admin-ajax.php",
            data: {
                action: "send_contactbox_formdata",
                'name_family': name_family,
                'email': email,
                'country': country,
                'mobile_phone': mobile_phone,
                'description': description,
            },
            success: function(response) {
                if (response.success) {
                    $(".lds-dual-ring").css("display", "none");
                    $(".error-call p").html(response.message);
                    $(".error-call").show();
                    setTimeout(() => {
                        $(".error-call").hide();
                        window.location.href = "https://ovalmattress.com/";
                    }, 3000);
                } else {
                    $(".lds-dual-ring").css("display", "none");
                    $(".error-call p").html(response.message);
                    $(".error-call").show();
                    setTimeout(() => {
                        $(".error-call").hide();
                    }, 3000);
                }
            },
            error: function() {
                alert("BOo!")
            }
        });
    });


})(jQuery);