<?php
/*
* Template Name: blog
*/
get_header(); 
?>


    <!-- Breadcrumb Begin -->
    <div class="breadcrumb-option spad">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="bo-links">
                        <a href="https://ovalmattress.com/"><i class="fa fa-home"></i> Home</a>
                        <span>Blog</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Blog Section Begin -->
    <section class="blog-section spad">
        <div class="container">
            <div class="row">
                <div class="col-lg-9">



                <?php
                // Example argument that defines three posts per page.
                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                    $query = new WP_Query( array(
                        'post_type' => 'post',
                                'paged' => $paged
                    ) );
                ?>
                
                <?php if ( $query->have_posts() ) : ?>  <?php while ( $query->have_posts() ) : $query->the_post(); ?> 
                    <a href="<?php the_permalink();?>" class="blog-item">
                        <div class="bi-pic">
                            <?php the_post_thumbnail('full'); ?>
                        </div>
                        <div class="bi-text">
                            <h5><?php the_title(); ?></h5>
                            <ul>
                                <li>by <span><?php echo get_the_author(); ?></span></li>
                                <li><?php the_time( 'F j, Y' );?></li>
                                <li><?php echo get_comments_number(); ?> comments</li>
                            </ul>
                            <p><?php echo wp_trim_words( get_the_content(), 50 ) ?></p>
                        </div>
                    </a>
                    <?php
                        // End the Loop
                    endwhile;
                    // If no posts match this query, output this text.
                else:
                    _e("Sorry, no posts matched your criteria.", "textdomain");
                endif;
                ?>
                    <div class="blog-pagination">
                        <?php 
                            echo paginate_links( array(
                                'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
                                'total'        => $query->max_num_pages,
                                'current'      => max( 1, get_query_var( 'paged' ) ), 
                                'format'       => '?paged=%#%',
                                'show_all'     => false,
                                'type'         => 'plain',
                                'end_size'     => 1,
                                'mid_size'     => 1,
                                'prev_next'    => true,
                                'prev_text'    => sprintf( '<i></i> %1$s', __( 'NEXT', 'text-domain' ) ),
                                'next_text'    => sprintf( '%1$s <i></i>', __( 'PREV', 'text-domain' ) ),
                                'add_args'     => false,
                                'add_fragment' => '',
                            ) );
                        ?>
                    </div>
                <?php
                wp_reset_postdata();
                ?> 
                    
                </div>
                <div class="col-lg-3">
                    <div class="blog-sidebar">
                        <div class="bs-item s-mb">
                            <h5>Feature posts</h5>
                            <div class="bi-feature-post">
                                <?php
                                    $args = [
                                        "post_type" => "post",
                                        "posts_per_page" => 5,
                                        "orderby" => 'rand',
                                    ];
                                    $the_query = new WP_Query($args);
                                    if ($the_query->have_posts()):
                                        // Start the Loop
                                        while ($the_query->have_posts()):
                                            $the_query->the_post();
                                        ?>
                                            <a href="#" class="fp-item">
                                                <div class="fp-pic">
                                                <?php the_post_thumbnail('full'); ?>
                                                </div>
                                                <div class="fp-text">
                                                    <h6><?php echo wp_trim_words( get_the_content(), 6 ) ?></h6>
                                                    <span><?php the_time( 'F j, Y' );?></span>
                                                </div>
                                            </a>
                                        <?php
                                        endwhile;
                                    else:
                                        _e("Sorry, no posts matched your criteria.", "textdomain");
                                    endif;
                                    wp_reset_postdata();
                                ?> 
                            </div>
                        </div>
                        
                        <div class="bs-item">
                            <h5>Instagram</h5>
                            <div class="bi-insta">
                                <img src="<?php bloginfo( 'template_url' ); ?>/assets/images/blog/insta-1.jpg" alt="">
                                <img src="<?php bloginfo( 'template_url' ); ?>/assets/images/blog/insta-2.jpg" alt="">
                                <img src="<?php bloginfo( 'template_url' ); ?>/assets/images/blog/insta-3.jpg" alt="">
                                <img src="<?php bloginfo( 'template_url' ); ?>/assets/images/blog/insta-4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog Section End -->


<?php
get_footer();
?>