<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> <?php twentytwentyone_the_html_classes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/font-awesome.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/elegant-icons.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/bootstrap.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/owl.carousel.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/owl.carousel.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/slicknav.css">
    <link rel="stylesheet" href="<?php bloginfo( 'template_url' ); ?>/assets/css/fancybox.css">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <!-- Page Preloder -->
    <div id="preloder">
        <div class="loader"></div>
    </div>

    <!-- Header Section Begin -->
    <header class="header-section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="logo">
                        <a href="./index.html">
                            <img width="177" src="<?php bloginfo( 'template_url' ); ?>/assets/images/logo.png" alt="">
                        </a>
                    </div>
                    <nav class="nav-menu mobile-menu">
                        <ul>
                            <li class="active"><a href="https://ovalmattress.com/">Home</a></li>
                            <li><a href="https://ovalmattress.com/portfolio/">Portfolio</a></li>
                            <li><a href="https://ovalmattress.com/blog/">Blog</a></li>
                            <li><a href="https://ovalmattress.com/contact">Contact</a></li>
                        </ul>
                    </nav>

                    <div id="mobile-menu-wrap"></div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header End -->
