<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

get_header();

/* Start the Loop */
while ( have_posts() ) :
	the_post();
	?>
<!-- Blog Details Section Begin -->
<?php $feat_image = wp_get_attachment_url( get_post_thumbnail_id($post->ID), 'full' );
  ?>
<div class="blog-hero set-bg" data-setbg="<?php echo $feat_image; ?>"></div>
    <section class="blog-details-section spad">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="blog-details-text">
                        <div class="bd-title">
                            <div class="bt-bread">
                                <a href="./index.html"><i class="fa fa-home"></i> Home</a>
                                <a href="./index.html">Blog</a>
                                <span><?php the_title(); ?></span>
                            </div>
                            <h2><?php the_title(); ?></h2>
                            <ul>
                                <li>by <span><?php echo get_the_author(); ?></span></li>
                                <li><?php the_time( 'F j, Y' );?></li>
                                <li><?php echo get_comments_number(); ?> comments</li>
                            </ul>
                        </div>
                        <div class="bd-top-text">
                            <?php
                                the_content();
                            ?>
                        </div>
                        <div class="bd-tag-share">
                            <div class="tags">
                            <?php 
                                $tags = get_tags(array('hide_empty' => false));
                                foreach ($tags as $tag) {
                                echo '<a>';
                                echo $tag->name;
                                echo '</a>';
                            }
                            ?>
                            </div>
                            <div class="share">
                                <?php
                                    // Get current page URL.
                                    $page_url = get_permalink();
                                    // Get current page title.
                                    $page_title = get_the_title();
                                ?>
                                <span>Share</span>
                                <a href="http://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()) ?>" class="facebook"><i class="fa fa-facebook"></i></a>
                                <a href="<?php echo "https://twitter.com/intent/tweet?text=' . $page_title . '&url=' .$page_url" ?>" class="twitter"><i class="fa fa-twitter"></i></a>
                                
                            </div>
                        </div>
                        
                        <div class="bd-comment-form">
                                    <div class="leave-form">
                                        <?php
                                            // If comments are open or there is at least one comment, load up the comment template.
                                            if ( comments_open() || get_comments_number() ) {
                                                comments_template();
                                            }
                                        ?>
                                    </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog Details Section End -->
    <?php


	

endwhile; // End of the loop.

get_footer();
